#pragma once

#include <boost/system/error_code.hpp>
#include <library/cpp/tvmauth/ticket_status.h>

namespace tvm_guard {

struct TicketParserWrapperCategory: public boost::system::error_category {
    const char* name() const noexcept override {
        return "tvm api ticket parser category";
    }

    std::string message(int) const override {
        return "invalid ticket";
    }

    static const TicketParserWrapperCategory& instance() {
        static TicketParserWrapperCategory instance;
        return instance;
    }

    static boost::system::error_code make_error() {
        return boost::system::error_code(0, instance());
    }
};

struct ServiceTicketCategory: public boost::system::error_category {
    const char* name() const noexcept override {
        return "tvm ticket error category";
    }

    std::string message(int v) const override {
        TStringBuf status = NTvmAuth::StatusToString(NTvmAuth::ETicketStatus(v));
        return std::string(status.data());
    }

    static const ServiceTicketCategory& instance() {
        static ServiceTicketCategory instance;
        return instance;
    }
};

}


namespace boost::system {

template<>
struct is_error_code_enum<NTvmAuth::ETicketStatus> {
    static constexpr bool value = true;
};

}

namespace NTvmAuth {
inline boost::system::error_code make_error_code(NTvmAuth::ETicketStatus err) {
    return boost::system::error_code(static_cast<int>(err), tvm_guard::ServiceTicketCategory::instance());
}
}
