#pragma once

#include <tvm_guard/helpers.h>
#include <library/cpp/tvmauth/client/facade.h>

namespace tvm_guard {
namespace detail {

template<>
bool TicketTraits<NTvmAuth::TCheckedServiceTicket>::ticketIsSuccessful(const NTvmAuth::TCheckedServiceTicket& ticket);

template<>
bool TicketTraits<NTvmAuth::TCheckedUserTicket>::ticketIsSuccessful(const NTvmAuth::TCheckedUserTicket& ticket);

template<>
std::string TicketTraits<NTvmAuth::TCheckedServiceTicket>::issuerUid(const NTvmAuth::TCheckedServiceTicket& ticket);

template<>
bool TicketTraits<NTvmAuth::TCheckedServiceTicket>::issuerUidIsEmpty(const NTvmAuth::TCheckedServiceTicket& ticket);

template<>
boost::optional<std::string> TicketTraits<NTvmAuth::TCheckedUserTicket>::defaultUid(const NTvmAuth::TCheckedUserTicket& ticket);

}

TString secretFromFile(const std::string& path);

NTvmAuth::NTvmApi::TClientSettings parseSettings(const boost::property_tree::ptree& node,
                                                       std::function<TString(const std::string&)> readSecretFromFile);
}
