#pragma once

#include <logdog/attribute.h>
#include <logdog/logger.h>
#include <library/cpp/tvmauth/client/logger.h>


namespace tvm_guard {

LOGDOG_DEFINE_ATTRIBUTE(std::string_view, tvm_client_message)

template<class Logger>
class TskvLogger: public NTvmAuth::ILogger {
    Logger logger_;

public:
    TskvLogger(const Logger& logger)
        : logger_(logger)
    { }

protected:
    void Log(int lvl, const TString& msg) override {

#define LOGDOG_TVM_CLIENT_HELPER(logdogLevel) LOGDOG_(logger_, logdogLevel,\
    tvm_client_message=std::string_view(msg.c_str(), msg.size()))

        switch(lvl) {
            case 7: LOGDOG_TVM_CLIENT_HELPER(debug);   break;
            case 6:
            case 5: LOGDOG_TVM_CLIENT_HELPER(notice);  break;
            case 4: LOGDOG_TVM_CLIENT_HELPER(warning); break;
            case 3:
            case 2:
            case 1: LOGDOG_TVM_CLIENT_HELPER(error);   break;

            default:
                LOGDOG_(logger_, error,
                        tvm_client_message=std::string_view(msg.c_str(), msg.size()),
                        logdog::message=std::string("unknown log level: ") + std::to_string(lvl));
            break;
        }

#undef LOGDOG_TVM_CLIENT_HELPER

    }
};

template<class Logger>
NTvmAuth::TLoggerPtr makeLogger(const Logger& logger) {
    return MakeIntrusive<TskvLogger<Logger>>(logger);
}

}
