#pragma once

#include <fstream>

#include <library/cpp/tvmauth/client/facade.h>
#include <library/cpp/tvmauth/client/logger.h>
#include <library/c/tvmauth/tvmauth.h>

#include <boost/property_tree/ptree.hpp>
#include <boost/system/error_code.hpp>
#include <boost/variant.hpp>

#include <mail/tvm_guard/tvm_api/error.h>
#include <mail/tvm_guard/tvm_api/helpers.h>
#include <tvm_guard/tvm_guard.h>
#include <logdog/logger.h>

namespace tvm_guard {

struct TvmApiWrapper {
    std::shared_ptr<NTvmAuth::TTvmClient> impl_;

    TvmApiWrapper(std::shared_ptr<NTvmAuth::TTvmClient> impl)
        : impl_(impl)
    { }

    boost::variant<boost::system::error_code, NTvmAuth::TCheckedServiceTicket>
        get_native_service_ticket_or_error(const std::string& ticket) const;

    boost::variant<boost::system::error_code, NTvmAuth::TCheckedUserTicket>
        get_native_user_ticket_or_error(TA_EBlackboxEnv, const std::string& ticket) const;
};

std::shared_ptr<TvmApiWrapper> getTvmApiWrapper(const boost::property_tree::ptree& node,
                                                const NTvmAuth::TLoggerPtr& logger);

}

namespace logdog {
namespace attr {
namespace tvm_guard {
LOGDOG_DEFINE_ATTRIBUTE(::tvm_guard::Guard<::tvm_guard::TvmApiWrapper>, module)
}
using namespace tvm_guard;
}
using namespace attr;
}
