#pragma once

#include <tvm_guard/helpers.h>
#include <ymod_tvm/module.h>

namespace tvm_guard::detail {

using ServiceTicket = NTvmAuthWrapper::TCheckedServiceTicket;
using UserTicket = NTvmAuthWrapper::TCheckedUserTicket;

template<>
bool TicketTraits<UserTicket>::ticketIsSuccessful(const UserTicket& ticket);

template<>
bool TicketTraits<ServiceTicket>::ticketIsSuccessful(const ServiceTicket& ticket);

template<>
std::string TicketTraits<ServiceTicket>::issuerUid(const ServiceTicket& ticket);

template<>
bool TicketTraits<ServiceTicket>::issuerUidIsEmpty(const ServiceTicket& ticket);

template<>
boost::optional<std::string> TicketTraits<UserTicket>::defaultUid(const UserTicket& ticket);

}
