#include <mail/tvm_guard/ymod_tvm/ymod_tvm.h>
#include <tvm_guard/module_impl.h>
#include <tvm_guard/log_tskv.h>
#include <tvm_guard/log.h>
#include <logdog/attributes/mail_attributes.h>

#include <yplatform/module_registration.h>
#include <ymod_webserver/codes.h>
#include <ymod_webserver/response.h>
#include <ymod_webserver/server.h>

namespace tvm_guard {

namespace {
template<class T>
void checkConfigExists(const std::string& name) {
    if (!yplatform::exists<T>(name)) {
        throw std::runtime_error("Cannot find config for module "+name);
    }
}
}
namespace log {
using namespace ::logdog::attr;
}

struct WithYModTvm: public ModuleImpl {
    WithYModTvm()
        : guardLogger_(getLogger(""))
    { }

    virtual ~WithYModTvm() { }

    void init(const yplatform::ptree& cfg) {
        guardLogger_ = getLogger(cfg.get<std::string>("logger.guard"));

        const std::string tvm = cfg.get<std::string>("dependencies.tvm");

        checkConfigExists<ymod_tvm::tvm2_module>(tvm);

        guard_ = std::make_shared<tvm_guard::Guard<ymod_tvm::tvm2_module>>(
            tvm_guard::init(
                cfg.get_child("guard"),
                getYModTvmWrapper(tvm)
            )
        );

        const auto l = getLogger(cfg.get<std::string>("logger.module"));
        LOGDOG_(l, notice, log::module=*guard_);
        LOGDOG_(l, notice, log::message="tvm_guard::WithYModTvm module initialized");
    }

    Response check(const ymod_webserver::request& req) const override {
        std::string uid;
        std::optional<std::string> service;
        std::optional<std::string> user;
        std::string reqId;
        std::string method = req.url.make_full_path();

        if (auto it = req.url.params.find("uid"); it != req.url.params.end()) {
            uid = it->second;
        }
        if (auto it = req.headers.find("x-ya-service-ticket"); it != req.headers.end()) {
            service = it->second;
        }
        if (auto it = req.headers.find("x-ya-user-ticket"); it != req.headers.end()) {
            user = it->second;
        }
        if (auto it = req.headers.find("x-request-id"); it != req.headers.end()) {
            reqId = it->second;
        }

        const auto tvm = guard_->check(method, uid, service, user);

        LOGDOG_(guardLogger_, notice, log::request_id=reqId,
                log::where_name=method, log::tvm_guard::response=tvm);

        return tvm;
    }

    Logger guardLogger_;
    std::shared_ptr<tvm_guard::Guard<ymod_tvm::tvm2_module>> guard_;
};

}

DEFINE_SERVICE_OBJECT(tvm_guard::WithYModTvm)
