#include <mail/tvm_guard/ymod_tvm/ymod_tvm.h>
#include <yplatform/find.h>

namespace tvm_guard {
namespace detail {

template<>
bool TicketTraits<UserTicket>::ticketIsSuccessful(const UserTicket& ticket) {
    return ticket.GetStatus() == TA_EC_OK;
}

template<>
bool TicketTraits<ServiceTicket>::ticketIsSuccessful(const ServiceTicket& ticket) {
    return ticket.GetStatus() == TA_EC_OK;
}

template<>
std::string TicketTraits<ServiceTicket>::issuerUid(const ServiceTicket& ticket) {
    return ticket.GetIssuerUid() ? std::to_string(ticket.GetIssuerUid()) : "none";
}

template<>
bool TicketTraits<ServiceTicket>::issuerUidIsEmpty(const ServiceTicket& ticket) {
    constexpr u_int64_t emptyIssuerUid = 0;

    return ticket.GetIssuerUid() == emptyIssuerUid;
}

template<>
boost::optional<std::string> TicketTraits<UserTicket>::defaultUid(const UserTicket& ticket) {
	boost::optional<std::string> ret;
    try {
        ret = std::to_string(ticket.GetDefaultUid());
    } catch (const std::exception&) { }

    return ret;
}

}

std::shared_ptr<ymod_tvm::tvm2_module> getYModTvmWrapper(const std::string& name) {
    return yplatform::find<ymod_tvm::tvm2_module, std::shared_ptr>(name);
}

}
