import yatest
import json
import os
import time
import requests


def prettify(json_text):
    return json.dumps(json.loads(json_text), indent=2, separators=(',', ':'))


def check_unistat_output():
    with open("recipe.port") as f:
        port = int(f.read())
    while (not os.path.isfile("recipe.done")):
        time.sleep(1)

    unistat_response = requests.get("http://localhost:{}/unistat".format(port))
    path = 'unistat_response.json'
    with open(path, 'w') as f:
        f.write(prettify(unistat_response.text))
    return yatest.common.canonical_file(path, local=True)
