from count_by_condition_cpp cimport (
    Counter as CounterImpl,
    Condition as ConditionImpl,
    ConditionStrPairVec,
)
from libcpp.string cimport string
from libcpp.memory cimport make_shared
from libcpp.utility cimport move
from meters import with_sigopt_suffix


cdef class Counter: 
    def __cinit__(self, string key, ConditionStrPairVec filter2signal, ConditionStrPairVec baseFilters):
        self.__impl = make_shared[CounterImpl](move(key), move(filter2signal), move(baseFilters))


cdef class ConditionEnum:
    Equals = ConditionImpl.Equals
    Contains = ConditionImpl.Contains
    AnyStr = ConditionImpl.AnyStr


cdef class Condition:
    @staticmethod
    def Equals(str):
        return (ConditionEnum.Equals, str)

    @staticmethod
    def Contains(str):
        return (ConditionEnum.Contains, str)

    @staticmethod
    def AnyStr():
        return (ConditionEnum.AnyStr, '')


def Signal(cond, name):
    return (cond, name)


def Filter(key, cond):
    return (cond, key)


def update_signal_names(cond2sig, prefix, suffix):
    res = []
    for cond, sig in cond2sig:
        sig = with_sigopt_suffix(prefix.format(sig), suffix)
        res.append(Signal(cond, sig))
    return res
