from libcpp.vector cimport vector
from libcpp.string cimport string
from libcpp.utility cimport pair

cdef extern from "mail/unistat/cpp/include/meters/count_by_condition.h" namespace "unistat::CountByCondition":
    enum Condition:
        Equals,
        Contains,
        AnyStr,
    
    ctypedef pair[Condition, string]        ConditionPair
    ctypedef pair[ConditionPair, string]    ConditionStrPair
    ctypedef vector[ConditionStrPair]       ConditionStrPairVec

    cdef cppclass Counter:
        Counter(string key, ConditionStrPairVec filter2signal, ConditionStrPairVec baseFilters)
