cimport logs_cpp
from meters cimport *
from count_by_condition cimport Counter

from libcpp.vector cimport vector
from cpython cimport *


cdef class SupervisorLog:
    def __cinit__(self, pyMeters, cppMeters, bint fastForward, bytes path):
        cdef vector[PyObject *] pm
        for m in pyMeters:
            pm.push_back(<PyObject *>m)
        cdef vector[logs_cpp.SupervisorMeters] cm
        for m in cppMeters:
            if isinstance(m, SupervisorLogRestartMeters):
                cm.push_back(logs_cpp.SupervisorMeters((<SupervisorLogRestartMeters>m).__impl))
            else:
                raise AttributeError("Unknown meter type for SupervisorLog")
        self.__impl.reset(new logs_cpp.SupervisorLog(pm, cm, fastForward, <const char*>path))


cdef class AccessTskv:
    def __cinit__(self, pyMeters, cppMeters, bint fastForward, bytes path):
        cdef vector[PyObject *] pm
        for m in pyMeters:
            pm.push_back(<PyObject *>m)
        cdef vector[logs_cpp.AccessLogMeters] cm
        for m in cppMeters:
            if isinstance(m, AccessLogCount):
                cm.push_back(logs_cpp.AccessLogMeters((<AccessLogCount>m).__impl))
            elif isinstance(m, AccessLogCountByPath):
                cm.push_back(logs_cpp.AccessLogMeters((<AccessLogCountByPath>m).__impl))
            elif isinstance(m, AccessLogCountByFirstStatusDigit):
                cm.push_back(logs_cpp.AccessLogMeters((<AccessLogCountByFirstStatusDigit>m).__impl))
            elif isinstance(m, AccessLogCountByPathAndFirstStatusDigit):
                cm.push_back(logs_cpp.AccessLogMeters((<AccessLogCountByPathAndFirstStatusDigit>m).__impl))
            elif isinstance(m, AccessLogRequestTimeHist):
                cm.push_back(logs_cpp.AccessLogMeters((<AccessLogRequestTimeHist>m).__impl))
            elif isinstance(m, AccessLogRequestTimeHistByPath):
                cm.push_back(logs_cpp.AccessLogMeters((<AccessLogRequestTimeHistByPath>m).__impl))
            else:
                raise AttributeError("Unknown meter type for AccessTskv")
        self.__impl.reset(new logs_cpp.AccessTskv(pm, cm, fastForward, <const char*>path))


cdef class HttpClientLog:
    def __cinit__(self, pyMeters, cppMeters, bint fastForward, bytes path):
        cdef vector[PyObject *] pm
        for m in pyMeters:
            pm.push_back(<PyObject *>m)
        cdef vector[logs_cpp.HttpClientMeters] cm
        for m in cppMeters:
            if isinstance(m, HttpClientHttpRequestCountByStatus):
                cm.push_back(logs_cpp.HttpClientMeters((<HttpClientHttpRequestCountByStatus>m).__impl))
            elif isinstance(m, HttpClientHttpRequestTotalTimeHist):
                cm.push_back(logs_cpp.HttpClientMeters((<HttpClientHttpRequestTotalTimeHist>m).__impl))
            else:
                raise AttributeError("Unknown meter type for HttpClientLog")
        self.__impl.reset(new logs_cpp.HttpClientLog(pm, cm, fastForward, <const char*>path))


cdef class TskvLog:
    def __cinit__(self, pyMeters, cppMeters, bint fastForward, bytes path):
        cdef vector[PyObject *] pm
        for m in pyMeters:
            pm.push_back(<PyObject *>m)
        cdef vector[logs_cpp.TskvMeters] cm
        for m in cppMeters:
            if isinstance(m, CountErrors):
                cm.push_back(logs_cpp.TskvMeters((<CountErrors>m).__impl))
            elif isinstance(m, Counter):
                cm.push_back(logs_cpp.TskvMeters((<Counter>m).__impl))
            else:
                raise AttributeError("Unknown meter type for TskvLog")
        self.__impl.reset(new logs_cpp.TskvLog(pm, cm, fastForward, <const char*>path))


cdef class PaLog:
    def __cinit__(self, pyMeters, cppMeters, bint fastForward, bytes path):
        cdef vector[PyObject *] pm
        for m in pyMeters:
            pm.push_back(<PyObject *>m)
        cdef vector[logs_cpp.PaMeters] cm
        for m in cppMeters:
            if isinstance(m, PaLogRequestTimeHist):
                cm.push_back(logs_cpp.PaMeters((<PaLogRequestTimeHist>m).__impl))
            else:
                raise AttributeError("Unknown meter type for PaLog")
        self.__impl.reset(new logs_cpp.PaLog(pm, cm, fastForward, <const char*>path))
