cimport meters_cpp

from libcpp.vector cimport vector


cdef class AccessLogCount:
    def __cinit__(self, bytes name):
        self.__impl.reset(new meters_cpp.AccessLogCount(<const char*>name))


cdef class AccessLogCountByPath:
    def __cinit__(self, bytes name, bytes endpoint):
        self.__impl.reset(new meters_cpp.AccessLogCountByPath(<const char*>name, <const char*>endpoint))


cdef class AccessLogCountByFirstStatusDigit:
    def __cinit__(self, bytes name):
        self.__impl.reset(new meters_cpp.AccessLogCountByFirstStatusDigit(<const char*>name))


cdef class AccessLogCountByPathAndFirstStatusDigit:
    def __cinit__(self, bytes name, bytes endpoint):
        self.__impl.reset(new meters_cpp.AccessLogCountByPathAndFirstStatusDigit(<const char*>name, <const char*>endpoint))


cdef class AccessLogRequestTimeHist:
    def __cinit__(self, vector[long] buckets, bytes name):
        self.__impl.reset(new meters_cpp.AccessLogRequestTimeHist(buckets, <const char*>name))


cdef class AccessLogRequestTimeHistByPath:
    def __cinit__(self, vector[long] buckets, bytes name, bytes endpoint):
        self.__impl.reset(new meters_cpp.AccessLogRequestTimeHistByPath(buckets, <const char*>name, <const char*>endpoint))


cdef class CountErrors:
    def __cinit__(self, bytes errorText, bytes namePrefix = b""):
        self.__impl.reset(new meters_cpp.CountErrors(<const char*>errorText, <const char*>namePrefix))


cdef class SupervisorLogRestartMeters:
    def __cinit__(self, bytes namePrefix):
        self.__impl.reset(new meters_cpp.SupervisorLogRestartMeters(<const char*>namePrefix))


cdef class HttpClientHttpRequestCountByStatus:
    def __cinit__(self, bytes endpoint, bytes namePrefix):
        self.__impl.reset(new meters_cpp.HttpClientHttpRequestCountByStatus(<const char*>endpoint,
                <const char*>namePrefix))


cdef class HttpClientHttpRequestTotalTimeHist:
    def __cinit__(self, vector[long] buckets, bytes uriFilter, bytes namePrefix):
        self.__impl.reset(new meters_cpp.HttpClientHttpRequestTotalTimeHist(buckets,
                <const char *>uriFilter, <const char*>namePrefix))


cdef class PaLogRequestTimeHist:
    def __cinit__(self, vector[long] buckets, bytes serviceFilter, bytes namePrefix):
        self.__impl.reset(new meters_cpp.PaLogRequestTimeHist(buckets, <const char *>serviceFilter, <const char*>namePrefix))


def with_sigopt_suffix(value, suffix):
    return value + suffix if value[-1] == '_' or suffix[0] == '_' else '%s_%s' % (value, suffix)
