from libcpp.vector cimport vector

cdef extern from "mail/unistat/cpp/include/meters.h" namespace "unistat":
    cdef cppclass AccessLogCount:
        AccessLogCount(const char* name)

    cdef cppclass AccessLogCountByPath:
        AccessLogCountByPath(const char* name, const char* endpoint)

    cdef cppclass AccessLogCountByFirstStatusDigit:
        AccessLogCountByFirstStatusDigit(const char* name)

    cdef cppclass AccessLogCountByPathAndFirstStatusDigit:
        AccessLogCountByPathAndFirstStatusDigit(const char* name, const char* endpoint)

    cdef cppclass HttpClientHttpRequestCountByStatus:
        HttpClientHttpRequestCountByStatus(const char* endpoint, const char* namePrefix)

    cdef cppclass AccessLogRequestTimeHist:
        AccessLogRequestTimeHist(vector[long] buckets, const char* namePrefix)

    cdef cppclass AccessLogRequestTimeHistByPath:
        AccessLogRequestTimeHistByPath(vector[long] buckets, const char* namePrefix, const char* endpoint)

    cdef cppclass CountErrors:
        CountErrors(const char* errorText, const char* namePrefix)

    cdef cppclass SupervisorLogRestartMeters:
        SupervisorLogRestartMeters(const char* namePrefix)

    cdef cppclass HttpClientHttpRequestTotalTimeHist:
        HttpClientHttpRequestTotalTimeHist(vector[long] buckets, const char* uriFilter, const char* namePrefix)

    cdef cppclass PaLogRequestTimeHist:
        PaLogRequestTimeHist(vector[long] buckets, const char* serviceFilter, const char* namePrefix)
