from cpython cimport *
from libcpp.vector cimport vector
from libcpp.memory cimport shared_ptr

from mail.unistat.cpp.cython.logs cimport *
cimport mail.unistat.cpp.cython.run_cpp
cimport service_logs_cpp


def run(host, port, pyLogs, yplatformLogPath, logLevel):
    cdef vector[logs_cpp.Logs] cppLogs
    for l in pyLogs:
        if isinstance(l, AccessTskv):
            cppLogs.push_back(
                logs_cpp.Logs((<AccessTskv>l).__impl)
            )
        elif isinstance(l, HttpClientLog):
            cppLogs.push_back(
                logs_cpp.Logs((<HttpClientLog>l).__impl)
            )
        else:
            raise AttributeError("Unknown log type")
    mail.unistat.cpp.cython.run_cpp.run(host, port, cppLogs, yplatformLogPath, logLevel)
