from library.python.testing.recipe import declare_recipe
from yatest.common import data_path, work_path, build_path, source_path
from mail.unistat.cpp.cython.canonize.recipe import find_free_port, start_unistat, stop_unistat


def start_service_unistat(argv):
    port = find_free_port()

    script_path = source_path('mail/unistat/cpp/example/cython/service_unistat.py')
    unistat_cmd = f"{build_path('mail/unistat/cpp/example/cython/cunistat')} {script_path} -d {work_path('')} -H '::' -p {str(port)}" \
                  f" -l {work_path('unistat.log')} {data_path('mops.yml')}"

    file_names = ['http_client.tskv', 'access.tskv']

    start_unistat(script_path, unistat_cmd, file_names, port)


if __name__ == "__main__":
    declare_recipe(start_service_unistat, stop_unistat)
