#pragma once

#include <mail/unistat/cpp/include/base_logs.h>
#include <mail/unistat/cpp/include/readers/readers.h>
#include <mail/unistat/cpp/include/meters.h>
#include <mail/unistat/cpp/include/signal_record.h>

namespace unistat {

using SupervisorMeters = std::variant<std::shared_ptr<SupervisorLogRestartMeters>>;
using SupervisorLog = Log<TextFileReader, File, IdentityParser, SupervisorMeters>;
using SupervisorLogPtr = std::shared_ptr<SupervisorLog>;

using AccessLogMeters = std::variant<std::shared_ptr<AccessLogCount>, std::shared_ptr<AccessLogCountByPath>,
        std::shared_ptr<AccessLogCountByFirstStatusDigit>, std::shared_ptr<AccessLogCountByPathAndFirstStatusDigit>,
        std::shared_ptr<AccessLogRequestTimeHist>, std::shared_ptr<AccessLogRequestTimeHistByPath>>;
using AccessTskv = Log<TextFileReader, File, TskvParser, AccessLogMeters>;
using AccessTskvPtr = std::shared_ptr<AccessTskv>;

using HttpClientMeters = std::variant<std::shared_ptr<HttpClientHttpRequestTotalTimeHist>,
        std::shared_ptr<HttpClientHttpRequestCountByStatus>>;
using HttpClientLog = Log<TextFileReader, File, TskvParser, HttpClientMeters>;
using HttpClientLogPtr = std::shared_ptr<HttpClientLog>;

using TskvMeters = std::variant<std::shared_ptr<CountSubstring>, CountByCondition::CounterPtr>;
using TskvLog = Log<TextFileReader, File, TskvParser, TskvMeters>;
using TskvLogPtr = std::shared_ptr<TskvLog>;

using PaMeters = std::variant<std::shared_ptr<PaLogRequestTimeHist>>;
using PaLog = Log<PaReader, File, PaParser, PaMeters>;
using PaLogPtr = std::shared_ptr<PaLog>;

} // namespace unistat
