#pragma once

#include <memory>

#include <yplatform/log.h>

#include <logdog/logger.h>
#include <logdog/format/tskv.h>
#include <logdog/backend/yplatform_log.h>

namespace unistat {

using namespace ::logdog::attr;

LOGDOG_DEFINE_ATTRIBUTE(std::string_view, line)
LOGDOG_DEFINE_ATTRIBUTE(std::string, source_name)

constexpr static auto unistat_formatter = ::logdog::tskv::make_formatter(BOOST_HANA_STRING("mail-unistat-tskv-log"));

inline auto getLogger() {
    auto logger = std::make_shared<yplatform::log::source>(YGLOBAL_LOG_SERVICE);
    return ::logdog::make_log(unistat_formatter, logger);
}

using Logger = decltype(getLogger());

} // namespace unistat
