#pragma once

#include <mail/unistat/cpp/include/signal_record.h>
#include <mail/unistat/cpp/include/meters/common.h>

#include <boost/range/adaptor/transformed.hpp>

namespace unistat {

template <typename BucketBound = std::chrono::milliseconds, template<typename> typename H = Hist>
struct PaLogRequestTimeHistBase {
    template <typename T>
    explicit PaLogRequestTimeHistBase(
        std::vector<T> buckets
        , const std::string& typeFilter = ""
        , const std::string& namePrefix = "pa"
    )
        : _typeFilter()
        , _impl(std::move(buckets), normalizeName(buildSignalName(namePrefix, typeFilter)))
    {
        if (!typeFilter.empty()) {
            _typeFilter = PaRecordTypes::fromString(typeFilter);
        }
    }

    void update(const PaRecord& record) {
        if (!_typeFilter || *_typeFilter == record.type) {
            _impl.update(std::chrono::milliseconds(record.spent_ms));
        }
    }

    auto get() const {
        return _impl.get();
    }

private:
    std::optional<uint32_t> _typeFilter;
    H<BucketBound> _impl;
};

using PaLogRequestTimeHist = PaLogRequestTimeHistBase<>;

} // namespace unistat
