#pragma once

#include <map>
#include <string>
#include <string_view>

namespace unistat {

namespace detail {

template <typename T>
concept Bool = std::is_same_v<T, bool>;

template <typename T>
concept RequestMatcher = requires(T m, std::string_view request) {
    { T(std::string_view{}) };
    { m.match(request) } -> Bool;
};

}

/**
 * Assumes that all incoming requests have form [/]path[/][?query_string].
 * |path| is supposed to be non-empty.
 * Case of multiple consecutive slashes is handled only at the beginning and at the end.
 */
class PathMatcher {
public:
    PathMatcher(std::string_view path) : path(getPath(path)) {
    }

    bool match(std::string_view request) const {
        return path == getPath(request);
    }

    std::string_view getPath(std::string_view request) const;

private:
    const std::string path;
};

class SubstringMatcher {
public:
    SubstringMatcher(std::string_view substring) : substring(substring) {
    }

    bool match(std::string_view request) const noexcept {
        return request.find(substring) != request.npos;
    }

private:
    const std::string substring;
};

}
