#pragma once

#include <chrono>
#include <string>
#include <optional>
#include <map>

#include <pa/interface.h>
#include <user_journal/enumeration.h>

namespace unistat {

struct IdentityParser {
    static std::optional<std::string_view> parse(std::string_view line) {
        return line;
    }
};

using PaRecord = pa::wmi_profiler_entry;

#define PROFILER_ENUMERATOR(TYPE) TYPE,
#define PA_RECORD_TYPES_ENUMERATOR(TYPE) map.insert(Map::value_type(Enum::TYPE, #TYPE));

struct __PaRecordTypes {
    enum Enum {
        unknown = 0,
        PROFILER_REM_TYPES(PROFILER_ENUMERATOR)
    };
    using Map = user_journal::Enum2String<Enum>::Map;
    using Filler = __PaRecordTypes;

    void fill(Map & map) const {
        map.insert(Map::value_type(Enum::unknown, "unknown"));
        PROFILER_REM_TYPES(PA_RECORD_TYPES_ENUMERATOR)
    }
};

#undef PA_RECORD_TYPES_ENUMERATOR
#undef PROFILER_ENUMERATOR

using PaRecordTypes = user_journal::Enumeration<__PaRecordTypes>;

struct TskvParser {
    static std::optional<std::map<std::string, std::string>> parse(std::string_view line);
};

struct PaParser {
    static std::optional<PaRecord> parse(std::string_view record);
};

} // namespace unistat
