#include <mail/unistat/cpp/include/meters/request_matcher.h>

#include <stdexcept>

namespace unistat {

std::string_view PathMatcher::getPath(const std::string_view request) const {
    auto result = request;

    if (const auto questionMark = result.find('?'); questionMark != result.npos) {
        result.remove_suffix(result.length() - questionMark);
    }

    if (const auto firstNotSlash = result.find_first_not_of('/'); firstNotSlash != result.npos) {
        result.remove_prefix(firstNotSlash);
    } else {
        throw std::invalid_argument("PathMatcher::getPath(): request=" + std::string(request));
    }

    if (const auto lastNotSlash = result.find_last_not_of('/'); lastNotSlash != result.npos) {
        result.remove_suffix(result.length() - (lastNotSlash + 1));
    } else {
        throw std::logic_error("PathMatcher::getPath(): unexpected state; request=" + std::string(request));
    }

    return result;
}

}
