#include <mail/unistat/cpp/include/readers/file.h>

#include <cstring>
#include <cerrno>

namespace unistat {

void File::open(bool fastForward) {
    const int fd = ::open(_path.c_str(), 0);
    if (-1 == fd) {
        throw std::runtime_error("Can't open file " + _path + ". Error: " + std::strerror(errno));
    }

    const struct stat statBuf = getStat();

    _inode = statBuf.st_ino;
    if (fastForward) {
        ::lseek(fd, 0, SEEK_END);
        if (0 != alignment()) {
            const auto offset = ::lseek(fd, 0, SEEK_CUR) % alignment();
            ::lseek(fd, -offset, SEEK_END);
        }
    }
    _fd.assign(fd);
}

struct stat File::getStat() const {
    struct stat statBuf;
    if (-1 == stat(_path.c_str(), &statBuf)) {
        throw std::runtime_error("Can't stat file " + _path + ". Error: " + std::strerror(errno));
    }
    return statBuf;
}

} // namespace unistat
