#include <mail/unistat/cpp/include/signal_record.h>

#include <mail/webmail/tskv/parser.h>

namespace unistat {

std::optional<std::map<std::string, std::string>> TskvParser::parse(std::string_view logLine) {
    return webmail::tskv::parse(logLine);
}

std::optional<PaRecord> PaParser::parse(std::string_view record) {
    if (record.size() == sizeof(PaRecord)) {
        return *reinterpret_cast<const PaRecord *>(record.data());
    } else {
        return std::nullopt;
    }
}

} // namespace unistat
