# unistat

Python-модуль для создания unistat-демона.

## Описание

Библиотека-конструктор многопроцессного демона для выдачи статистики отображаемой в
[golovan](http://yasm.yandex-team.ru/). На каждый файл создается процесс-читатель, который читает файл и считает метрики.
Результаты передаются в основной процесс через объекты в shared-memory. Основной процесс запускает HTTP-сервер,
который на каждый запрос берет метрики из кеша и возвращает в специальном JSON-формате.

## Использование

В этом репозитории находится база для конфигурации и запуска демона. Здесь нету функции main.
Так сделано, потому что у каждого сервиса свои метрики, свои пути до логов. Функцию main описываем в репозитории сервиса.
Там же определяем как запускать. Демонизацию процесса, если нужно, пишем сами.

Останавливать процесс нужно только сигналом SIGINT. Для supervisorctl можно использовать такие опции в конфиге:

```
stopsignal=INT
stopwaitsecs=3
killasgroup=true
```

Для логирования используется модуль [logging](https://docs.python.org/2/library/logging.html).
Всю конфигурацию нужно сделать самостоятельно перед запуском `run`.

### Процесс разработки unistat-демона

Чтобы собрать свой unistat-демон, нужно для каждого лог-файла:
1. Написать или использовать существующий класс для чтения файлов с методами:
    * `__init__(path: str)` -- конструктор;
    * `__call__(stop: threading.Event): str` -- возвращает генратор строк (записей) из файла,
    пока не выставлено событие stop. Проверку stop стоит делать не для каждой строки, если интенсивность чтения высокая.

2. Написать или использовать функцию парсинга строки лога. Принимает строчку от читателя файла. Возвращает распаршенное
занчение или `None`. Бросать исключения стоит только для неожиданно невалидного входа. Если запись нужно отфильтровать,
возвращаем `None`.

3. Написать или использовать существующий класс расчета метрики. Значения пишем в
[shared-memory объекты](https://docs.python.org/2/library/multiprocessing.html#sharing-state-between-processes).
    * `update(record)` -- вызывается в читающем процессе на каждую распаршенную не `None` запись. Предназначен для
    обновления значений метрики;
    * `get()` -- вызывается в основном процессе для выдачи результатов в ручке API. Возвращает список пригодный для
конвертации в JSON, соответствующий [формату метрики](https://wiki.yandex-team.ru/golovan/stat-handle/) для golovan
`meter(cache): list`, или словарь, который рекурсивно будет развернут в плоский список.

4. Создать список логов `unistat.run.Log`:
    * `path` -- путь к файлу;
    * `reader` -- класс чтения файла;
    * `parse_record` -- функция парсига строки файла;
    * `meters` -- список функций расчета метрик;

5. Вызвать функцию `unistat.run.run` со списком логов, чтобы запустить HTTP-сервер, который отвечает по ручкам:
* `GET /` -- описание всех ручек;
* `GET /ping` -- статус;
* `GET /unistat` -- получить метрики для golovan.

### Примечания

Если функциональность не используется нигде, кроме вашего сервиса, не нужно пытаться ее коммитить в этот репозиторий.

### Примеры

[Демон](examples/__main__.py) для сервиса [retriever](https://github.yandex-team.ru/mail/retriever).

```bash
env PYTHONPATH=${PWD} examples/__main__.py
```

В аркадии
```bash
ya make mail/unistat/examples
mail/unistat/examples/unistat_retriever_example
```
