# coding: utf-8

import json

from werkzeug import routing
from werkzeug.exceptions import HTTPException
from werkzeug.routing import Rule
from werkzeug.wrappers import Request, Response


class Api(object):
    url_map = routing.Map([
        Rule('/', endpoint='describe'),
        Rule('/ping', endpoint='ping', methods=('GET',)),
        Rule('/unistat', endpoint='unistat', methods=('GET',)),
    ])

    def __init__(self, meters):
        self.__meters = meters

    @staticmethod
    def ping(_request):
        return Response('pong')

    def describe(self, _request):
        return Response(str(self.url_map))

    def unistat(self, _request):
        return Response(
            response=json.dumps(make_response(meters=self.__meters)),
            headers={'content-type': 'application/json'},
        )

    def dispatch_request(self, request):
        adapter = self.url_map.bind_to_environ(request.environ)
        try:
            endpoint, values = adapter.match()
            return getattr(self, endpoint)(request, **values)
        except HTTPException as e:
            return Response(response=e.description, status=e.code)

    def __call__(self, environ, start_response):
        request = Request(environ)
        response = self.dispatch_request(request)
        return response(environ, start_response)


def make_response(meters):
    def impl():
        for meter in meters:
            for reflected in reflect_metric(meter.get()):
                yield reflected
    return list(impl())


def reflect_metric(metric):
    if isinstance(metric, dict):
        for v in metric.values():
            for reflected in reflect_metric(v):
                yield reflected
    else:
        yield metric
