# coding: utf-8

import re
from statbox_bindings2.string_utils.simple_parsers import parse_tskv


def identity(line):
    return line


def parse_nginx_access_log_record(line):
    return get_group_dict_or_none(NGINX_ACCESS_LOG_RECORD.match(line.strip()))


NGINX_ACCESS_LOG_RECORD = re.compile(
    r'\[(?P<time_local>[^\[\]]+)\]'
    r' (?P<host>[^ ]+)'
    r' (?P<remote_addr>[^ ]+)'
    r' "(?P<request>[^"]+)"'
    r' (?P<status>\d+)'
    r' "(?P<http_referer>[^"]*)"'
    r' "(?P<http_user_agent>[^"]*)"'
    r' "(?P<http_cookie>[^"]*)"'
    r' "(?P<http_x_forwarded_for>[^"]*)"'
    r'(?: "(?P<request_id>[^"]*)")?'
    r' (?P<request_length>\d+)'
    r' (?P<bytes_sent>\d+)'
    r' (?P<request_time>[^ ]+)'
)


def parse_ymod_webserver_access_log_record(line):
    return get_group_dict_or_none(YMOD_WEBSERVER_ACCESS_LOG_RECORD.match(line.strip()))


YMOD_WEBSERVER_ACCESS_LOG_RECORD = re.compile(
    r'\[(?P<time_local>[^\[\]]+)\]'
    r' (?P<host>[^ ]+)'
    r' (?P<remote_addr>[^ ]+)'
    r' "(?P<request>[^"]+)"'
    r' (?P<status>\d+)'
    r' "(?P<http_referer>[^"]*)"'
    r' "(?P<http_user_agent>[^"]*)"'
    r' "(?P<http_cookie>[^"]*)"'
    r' "(?P<http_x_forwarded_for>[^"]*)"'
    r' (?P<ssl>[^ ]*)'
    r' "(?P<request_id>[^ ]*)'
    r'(?: "(?P<headers>[^"]*)")?'
    r' (?P<request_time>[^ ]+)'
)


def parse_ymod_httpclient_log_event(line):
    return parse_ymod_httpclient_log_event_start(line) or parse_ymod_httpclient_log_event_fin(line)


def parse_ymod_httpclient_log_event_start(line):
    return get_group_dict_or_none(YMOD_HTTPCLIENT_EVENT_START.match(line.strip())) if 'event=start' in line else None


YMOD_HTTPCLIENT_EVENT_START = re.compile(
    r'\[(?P<time>[^\]]+)\]'
    r' .*'
    r' (?P<session_id>\w+)\S*'
    r' conn=(?P<conn>\w+)'
    r' req=(?P<req>\w+)'
    r' event=(?P<event>start)'
    r' uri="(?P<uri>[^"]*)"'
    r'(?: headers=\[(?P<headers>[^\]]*)\])?'
)


def parse_ymod_httpclient_log_event_fin(line):
    return get_group_dict_or_none(YMOD_HTTPCLIENT_EVENT_FIN.match(line.strip())) if 'event=fin' in line else None


YMOD_HTTPCLIENT_EVENT_FIN = re.compile(
    r'\[(?P<time>[^\[\]]+)\]'
    r' .*'
    r' (?P<session_id>\w+)\S*'
    r' conn=(?P<conn>\w+)'
    r' req=(?P<req>\w+)'
    r' event=(?P<event>fin)'
    r' tm={(?P<resolve_time>[^,]+), (?P<connect_time>[^,]+), (?P<tls_time>[^,]+), (?P<total_time>[^,]+)}'
    r' status=(?P<status>\d+)'
    r' attempt=(?P<attempt>\d+)'
    r' bytes_out=(?P<bytes_out>\d+)'
    r' bytes_in=(?P<bytes_in>\d+)'
)


def get_group_dict_or_none(match):
    return None if match is None else match.groupdict()


def parse_tskv_log_record(line):
    return parse_tskv(line)
