import copy
import logging
import yaml

from collections import OrderedDict

log = logging.getLogger('unistat')


def read_yplatform_config(path):
    log.info('read config from %s', path)
    with open(path) as f:
        data = yaml.load(f)
        if 'base' in data:
            log.info('found base config %s', data['base'])
            base = read_yplatform_config(data['base'])
            data = merge_yplatform_config(base=base, current=data)
    return data


def merge_yplatform_config(base, current):
    if isinstance(base, dict):
        return merge_yplatform_config_dict(base=base, current=current)
    elif isinstance(base, list):
        return merge_yplatform_config_list(base=base, current=current)
    else:
        return copy.deepcopy(current)


def merge_yplatform_config_dict(base, current):
    result = dict()
    for base_key, base_value in base.iteritems():
        if base_key in current:
            result[base_key] = merge_yplatform_config(base=base_value, current=current[base_key])
        else:
            result[base_key] = copy.deepcopy(base_value)
    for current_key, current_value in current.iteritems():
        if current_key not in base:
            result[current_key] = copy.deepcopy(current_value)
    return result


def merge_yplatform_config_list(base, current):
    items = OrderedDict()
    for base_value in base:
        if '_name' in base_value:
            items[base_value['_name']] = base_value
    for current_value in current:
        if '_name' in current_value:
            if current_value['_name'] in items:
                items[current_value['_name']] = merge_yplatform_config(
                    base=items[current_value['_name']],
                    current=current_value,
                )
            else:
                items[current_value['_name']] = current_value
        else:
            items[id(current_value)] = current_value
    return [copy.deepcopy(v) for v in items.values()]
