#include <mail/user_journal/helpers/geobase.h>

namespace user_journal {

struct Geobase::Lookup {
    std::shared_ptr<NGeobase::TLookup> impl;

    Lookup(const std::string& path)
        : impl(std::make_shared<NGeobase::TLookup>(path))
    { }

    int region_id(const std::string& ip) const {
        return impl->GetRegionIdByIp(ip);
    }

    std::string asset(const std::string& ip) const {
        return impl->GetAsNameByIp(ip);
    }
};

Geobase::Geobase()
    : impl(nullptr)
{ }

Geobase::Geobase(const std::string& path)
    : impl(std::make_shared<Geobase::Lookup>(path))
{ }

int Geobase::getRegionId(const std::string& ip) const {
    try {
        if (impl) {
            return impl->region_id(ip);
        }
    } catch (...) {}
    return defaultId;
}

std::string Geobase::internetProvider(const std::string& ip) const {
    try {
        if (impl) {
            return impl->asset(ip);
        }
    } catch (...) {}
    return "unknown";
}

Geobase initGeodata(const boost::property_tree::ptree& node) {
    const std::string geodataFilePath = node.get<std::string>("geodata_path");
    if (geodataFilePath.empty()) {
        return Geobase();
    }

    return Geobase(geodataFilePath);
}

}
