#pragma once

#include <string>
#include <memory>
#include <boost/property_tree/ptree.hpp>
#include <library/cpp/geobase/lookup.hpp>


namespace user_journal {

struct Geobase {
    Geobase();
    Geobase(const std::string& path);

    int getRegionId(const std::string& ip) const;
    std::string internetProvider(const std::string& ip) const;

private:
    struct Lookup;
    static constexpr int defaultId = 225;

    std::shared_ptr<Lookup> impl;
};

Geobase initGeodata(const boost::property_tree::ptree& node);

}
