#include <mail/user_journal/helpers/get_fields.h>
#include <user_journal/parameters/parameter_id.h>

namespace user_journal {

std::tuple<parameters::id::operationSystem, parameters::id::browser> getFieldsFromUserAgent(const Uatraits& ua,
                                                                                            const std::string& userAgent) {
    using namespace user_journal::parameters;
    const auto info = ua.check(userAgent);
    return std::make_tuple(id::operationSystem{info.osName, info.osVersion},
                           id::browser{info.browserName, info.browserVersion});
}

std::tuple<parameters::id::regionId, parameters::id::internetProvider> getFieldsFromGeobase(const Geobase& g,
                                                                                            const std::string& ip) {
    using namespace user_journal::parameters;
    return std::make_tuple(id::regionId{g.getRegionId(ip)},
                           id::internetProvider{g.internetProvider(ip)});
}

}
