#include <mail/user_journal/helpers/uatraits.h>

namespace user_journal {

Uatraits::Uatraits()
    : impl(nullptr)
{  }

Uatraits::Uatraits(const std::string& config, const std::string& profiles)
    : impl(std::make_shared<uatraits::detector>(config.c_str(), profiles.c_str()))
{  }

Uatraits::UserInfo Uatraits::check(const std::string& userAgent) const {
    if (!impl) {
        return Uatraits::UserInfo{};
    }

    std::map<std::string, std::string> details;
    std::map<std::string, std::string> headers;
    headers["User-Agent"] = userAgent;
    headers["X-Wap-Profile"] = "";
    headers["X-Operamini-Phone-Ua"] = "";

    impl->detect(headers, details);

    return Uatraits::UserInfo{details["OSName"], details["OSVersion"],
                              details["BrowserName"], details["BrowserVersion"]};
}

Uatraits initUa(const boost::property_tree::ptree& node) {
    const std::string config = node.get<std::string>("config");
    const std::string profiles = node.get<std::string>("profiles");
    if (config.empty() || profiles.empty()) {
        return Uatraits();
    }
    return Uatraits(config, profiles);
}

}
