#pragma once

#include <string>
#include <memory>
#include <uatraits/detector.hpp>
#include <boost/property_tree/ptree.hpp>

namespace user_journal {

struct Uatraits {
    struct UserInfo {
        std::string osName;
        std::string osVersion;
        std::string browserName;
        std::string browserVersion;
    };

    Uatraits();
    Uatraits(const std::string& config, const std::string& profiles);

    UserInfo check(const std::string& userAgent) const;

    std::shared_ptr<uatraits::detector> impl;
};

Uatraits initUa(const boost::property_tree::ptree& node);

}
