#ifndef USER_JOURNAL_ASYNC_SERVICE_H
#define USER_JOURNAL_ASYNC_SERVICE_H

#include <user_journal/service.h>
#include <user_journal/connection_info.h>
#include <internal/mutations_sender_thread.h>
#include <internal/mutations_queue.h>
#include <internal/access_traits.h>

namespace user_journal {

class AsyncService : public Service, boost::noncopyable {
public:
    virtual ~AsyncService() = default;
    AsyncService(const AsyncConnectionInfo & connInfo );

protected:
    virtual WriterPtr writer() const override;

private:
    AccessTraits accessTraits;
    MutationsQueuePtr queue;
    MutationsSenderThread sender;
    std::locale locale;
};

} // namespace user_journal

#endif /* USER_JOURNAL_ASYNC_SERVICE_H */
