#ifndef LOG_EXCEPTION_H_164806032014
#define LOG_EXCEPTION_H_164806032014

#include <user_journal/exception_handler.h>
#include <user_journal/logging.h>
#include <iostream>

namespace user_journal {

class LogException : public ExceptionHandler {
public:
    LogException( logging::LogPtr logger, const std::string & method )
    : logger(logger), method(method) {}
    virtual void handle( const std::exception & e ) const {
        error(e.what());
    }
    virtual void handleUnknown() const {
        error("unknown exception");
    }
private:
    void error( const std::string & msg ) const {
        logger->error("", method, msg, 0 );
    }
    logging::LogPtr logger;
    std::string method;
};

class CerrLogException : public ExceptionHandler {
public:
    virtual void handle( const std::exception & e ) const {
        std::cerr << "user_journal:" << e.what() << std::endl;
    }
    virtual void handleUnknown() const {
        std::cerr << "user_journal: unknown exception" << std::endl;
    }
};

} // namespace user_journal


#endif /* LOG_EXCEPTION_H_164806032014 */
