#ifndef LOGGING_H_180812122013
#define LOGGING_H_180812122013

#include <user_journal/logging.h>

namespace user_journal {
namespace logging {

template <typename T>
auto call(T func, LogPtr logger, const std::string & method, const std::string & uid) {
    if(logger.get() ) {
        try {
            return func();
        } catch( const std::exception & e ) {
            logger->error(uid, method, e.what(), 0 );
        } catch( ... ) {
            logger->error(uid, method, "unknown exception", 0 );
        }
    } else {
        return func();
    }
    return decltype(func())();
}

} // namespace logging
} // namespace user_journal

#endif /* LOGGING_H_180812122013 */
