#ifndef MUTATIONS_QUEUE_H_151819022014
#define MUTATIONS_QUEUE_H_151819022014

#include <string>
#include <vector>
#include <queue>
#include <boost/shared_ptr.hpp>
#include <boost/noncopyable.hpp>
#include <boost/thread/mutex.hpp>

namespace user_journal {

class MutationsQueue {
public:
    typedef std::string TskvRow;
    typedef std::vector<TskvRow> TskvRowsChunk;

    virtual bool add( TskvRow rows ) = 0;
    virtual bool get( TskvRowsChunk& chunk ) = 0;
    virtual ~MutationsQueue() {}
};

typedef boost::shared_ptr<MutationsQueue> MutationsQueuePtr;

class MutationsQueueAlgo {
public:
    typedef MutationsQueue::TskvRowsChunk TskvRowsChunk;
    typedef MutationsQueue::TskvRow TskvRow;
    typedef std::queue<TskvRowsChunk> Queue;

    MutationsQueueAlgo(Queue & chunks, std::size_t maxChunkSize, std::size_t maxQueueSize)
    : chunks(chunks), maxChunkSize(maxChunkSize), maxQueueSize(maxQueueSize) {
        startNewChunk();
    }
    bool add( TskvRow rows ) const;
    bool get( TskvRowsChunk& chunk ) const;
private:
    void startNewChunk() const {
        chunks.push(TskvRowsChunk());
    }
    TskvRowsChunk & currentChunk() const {
        return chunks.back();
    }
    bool currentChunkMaxSizeExceeded() const {
        return currentChunk().size() == maxChunkSize;
    }
    bool maxQueueSizeExceeded() const {
        return chunks.size() == maxQueueSize;
    }
    Queue & chunks;
    std::size_t maxChunkSize;
    std::size_t maxQueueSize;
};

class MutationsQueueImpl : public MutationsQueue {
public:
    MutationsQueueImpl(std::size_t maxChunkSize, std::size_t maxQueueSize = 1000)
    : algorithm(chunks, maxChunkSize, maxQueueSize) {
    }
    bool add( TskvRow rows );
    bool get( TskvRowsChunk& chunk );
private:
    MutationsQueueAlgo::Queue chunks;
    MutationsQueueAlgo algorithm;
    boost::mutex mutex;
};


}// namespace user_journal

#endif /* MUTATIONS_QUEUE_H_151819022014 */
