#ifndef MUTATIONS_SENDER_H_154219022014
#define MUTATIONS_SENDER_H_154219022014

#include <internal/mutations_queue.h>
#include <user_journal/file_writer.h>
#include <user_journal/logging.h>
#include <string>
#include <map>

namespace user_journal {

class MutationsSender {
public:
    typedef MutationsQueue::TskvRowsChunk TskvRowsChunk;
    typedef MutationsQueue::TskvRow TskvRow;
    MutationsSender(MutationsQueuePtr queue, logging::LogPtr logger,
            FileWriter fileWriter)
    : queue(queue), logger(logger), fileWriter(fileWriter) {
    }

    void poll() const;
private:
    void send( const TskvRowsChunk & chunk) const;
    MutationsQueuePtr queue;
    logging::LogPtr logger;
    FileWriter fileWriter;

    static const std::string emptyUid;
};

} // namespace user_journal

#endif /* MUTATIONS_SENDER_H_154219022014 */
