#ifndef MUTATION_SENDER_THREAD_H_161226022014
#define MUTATION_SENDER_THREAD_H_161226022014

#include <internal/mutations_sender.h>
#include <boost/thread.hpp>
#include <boost/chrono/system_clocks.hpp>
#include <user_journal/exception_handler.h>
#include <user_journal/date.h>
#include <user_journal/logging.h>

namespace user_journal {

class MutationsSenderThread {
public:
    struct Poll {
        Poll(MutationsSender & sender, Milliseconds timeout,
                ExceptionHandlerPtr exceptionHandler)
        : sender(sender), timeout(timeout), exceptionHandler(exceptionHandler){
        }

        void operator() () const ;

        MutationsSender & sender;
        Milliseconds timeout;
        ExceptionHandlerPtr exceptionHandler;
    };

    MutationsSenderThread(MutationsQueuePtr queue,
            logging::LogPtr logger, Milliseconds timeout,
            ExceptionHandlerPtr exceptionHandler,
            FileWriter fileWriter);
    ~MutationsSenderThread();
private:
    MutationsSender sender;
    boost::thread thread;
};

} // namespace user_journal

#endif /* MUTATION_SENDER_THREAD_H_161226022014 */
