#ifndef HBASE_WRITE_HELPERS_H_160620022014
#define HBASE_WRITE_HELPERS_H_160620022014

#include <user_journal/enumeration.h>
#include <user_journal/date.h>
#include <user_journal/entry.h>
#include <yplatform/tskv/tskv.h>
#include <vector>
#include <boost/algorithm/string.hpp>

namespace user_journal {

template <typename Out>
struct EntryMapper : public user_journal::Mapper {
    Out& out;
    EntryMapper(Out& out) : out(out) {}

    void insert(const std::string& name, const std::string& value) const {
        if(!value.empty()) {
            out << ytskv::attr(name, value);
        }
    }

    template <typename T>
    void insert(const std::string& name, const Enumeration<T>& value) const {
        if (value != value.defaultValue) {
            out << ytskv::attr(name, value.toString());
        }
    }

    void mapValue(const Date& v, const std::string& name) const override {
        insert(name, std::to_string(v.time_since_epoch().count()));
    }

    void mapValue(const Operation& v, const std::string& name) const override {
        insert(name, v);
    }

    void mapValue(const Target& v, const std::string& name) const override {
        insert(name, v);
    }

    void mapValue(const std::string& v, const std::string& name) const override {
        insert(name, v);
    }

#define MAP_VALUE( type )\
    void mapValue( type v, const std::string & name ) const override {\
        out << ytskv::attr(name, v);\
    }

    MAP_VALUE(bool);
    MAP_VALUE(int);
    MAP_VALUE(size_t);
    MAP_VALUE(std::time_t);
#undef MAP_VALUE

    void mapValue(const std::vector<std::string>& v, const std::string& name) const override {
        insert(name, boost::algorithm::join(v, ","));
    }
};

} // namespace user_journal

#endif /* HBASE_WRITE_HELPERS_H_160620022014 */
