#ifndef INCLUDE_USER_JOURNAL_HBASE_CONNECTION_INFO_H_163617102014
#define INCLUDE_USER_JOURNAL_HBASE_CONNECTION_INFO_H_163617102014

#include <user_journal/date.h>
#include <user_journal/profiling.h>
#include <user_journal/logging.h>
#include <user_journal/exception_handler.h>
#include <user_journal/file_writer.h>
#include <string>

namespace user_journal {

extern const profiling::LogPtr noProfiling;
extern const logging::LogPtr noLogging;
extern const ExceptionHandlerPtr defaultExceptionHandler;
extern const ExceptionHandlerPtr cerrExceptionHandler;

struct ConnectionInfo {
    std::string tableName;
    std::string tskvFormat;
    std::size_t writeChunkSize;
    Milliseconds writePollTimeout;
    ExceptionHandlerPtr onSenderThreadException;
    profiling::LogPtr profiler;
    logging::LogPtr logger;
    FileWriter fileWriter;
    std::locale locale;
    ConnectionInfo()
    : tableName("users_history"), tskvFormat("mail-user-journal-tskv-log"),
      writeChunkSize(100), writePollTimeout(500),
      onSenderThreadException(defaultExceptionHandler),
      profiler(noProfiling), logger(noLogging), locale("") {
    }
};

typedef ConnectionInfo AsyncConnectionInfo;

ExceptionHandlerPtr logSenderException(logging::LogPtr logger);

}// namespace user_journal

#endif /* INCLUDE_USER_JOURNAL_HBASE_CONNECTION_INFO_H_163617102014 */
