#ifndef USER_JOURNAL_DATE_H_134202122013
#define USER_JOURNAL_DATE_H_134202122013

#include <boost/chrono/system_clocks.hpp>

namespace user_journal {

namespace date {

using namespace boost::chrono;
typedef time_point<system_clock, milliseconds> Date;
typedef hours Hours;
typedef milliseconds Milliseconds;
typedef minutes Minutes;

extern const Hours day;
extern const Hours week;
extern const Hours month;

template <typename T, typename D>
inline Date before( const duration<T, D> & period, const Date & d ) {
    return Date(d.time_since_epoch() - period);
}

inline Date dayBefore( const Date & d ) {
    return before(day, d);
}

inline Date weekBefore( const Date & d ) {
    return before(week, d);
}

inline Date monthBefore( const Date & d ) {
    return before(month, d);
}

}//namespace date

typedef date::Date Date;
typedef date::Hours Hours;
typedef date::Milliseconds Milliseconds;
typedef date::Minutes Minutes;

inline Date currentDate() {
    using namespace boost::chrono;
    return time_point_cast<milliseconds>(system_clock::now());
}

inline std::time_t unixtime(const Date& date) {
    using namespace boost::chrono;
    return duration_cast<boost::chrono::seconds>(date.time_since_epoch()).count();
}


} //namespace user_journal



#endif /* USER_JOURNAL_DATE_H_134202122013 */
