#ifndef USER_JOURNAL_ENTRY_OSTREAM_H
#define USER_JOURNAL_ENTRY_OSTREAM_H

#include <user_journal/entry.h>
#include <boost/algorithm/string.hpp>
#include <ostream>

namespace user_journal {
namespace detail {

struct Mapper : public user_journal::Mapper {
    std::ostream & s;
    Mapper(std::ostream & s) : s(s) {}

#define MAP_VALUE( type )\
    virtual void mapValue( type v, const std::string & name ) const override {\
        s << name << ": " << v << ";";\
    }

    MAP_VALUE(const Operation &);
    MAP_VALUE(const Target &);
    MAP_VALUE(const std::string &);
    MAP_VALUE(bool);
    MAP_VALUE(int);
    MAP_VALUE(size_t);
    MAP_VALUE(std::time_t);
#undef MAP_VALUE

    virtual void mapValue( const Date & v, const std::string & name ) const override {
        s << name << ": " << v.time_since_epoch().count() << "ms;";\
    }

    virtual void mapValue( const std::vector<std::string> & v, const std::string & name ) const override {
        s << name << ": " << boost::algorithm::join(v, ",") << ";";\
    }
};

}// namespace detail

inline std::ostream & operator << ( std::ostream & s, const Entry & e ) {
    e.map(detail::Mapper(s));
    return s;
}

}// namespace user_journal


#endif /* USER_JOURNAL_ENTRY_OSTREAM_H */
