#pragma once

#include <string>
#include <boost/bimap.hpp>

namespace user_journal {

template < typename Enum >
class Enum2String {
public:
    typedef Enum Value;
    typedef boost::bimap<Value,std::string> Map;
    template < typename Filler >
    Enum2String( Filler f ) {
        f.fill(map);
    }

    const std::string & toString( const Value & v ) const {
        using namespace std::literals;
        const auto i = map.left.find(v);
        if (i == map.left.end()) {
            throw std::out_of_range("bad enum key "s + std::to_string(static_cast<std::underlying_type_t<Value>>(v)));
        }
        return i->second;
    }

    Value fromString( const std::string & str ) const {
        using namespace std::literals;
        const auto i = map.right.find(str);
        if (i == map.right.end()) {
            throw std::out_of_range("bad string key \""s + str + '"');
        }
        return i->second;
    }

    Value fromString(const std::string & str, Value defaultVal) const {
        const auto i = map.right.find(str);
        return i == map.right.end() ? defaultVal : i->second;
    }

private:
    Map map;
};

} //namespace user_journal
