#pragma once

#include <user_journal/enum2string.h>
#include <iostream>
#include <string>

namespace user_journal {

template <typename EnumHolder, const typename EnumHolder::Enum defVal = EnumHolder::unknown >
class Enumeration : public EnumHolder {
public:
    typedef typename EnumHolder::Enum Enum;
    typedef typename EnumHolder::Filler Filler;
    Enumeration( Enum v = defaultValue) : v(v) {}
    Enum value() const {
        return v;
    }
    operator Enum () const {
        return value();
    }
    Enumeration & operator = ( Enum rhv ) {
        v = rhv;
        return *this;
    }
    bool operator == (const Enum & rhv) const {
        return value() == rhv;
    }
    bool operator != (const Enum & rhv) const {
        return !(*this == rhv);
    }

    std::string toString() const {
        return enum2string.toString(*this);
    }
    static Enum fromString(const std::string & str) {
        return enum2string.fromString(str);
    }

    static Enum fromString( const std::string & str, const std::nothrow_t & ) {
        return enum2string.fromString(str, defaultValue);
    }

    static const Enum defaultValue;
private:
    Enum v;
    static const Enum2String<Enum> enum2string;
};

template <typename EnumHolder, const typename EnumHolder::Enum defVal>
const Enum2String<typename EnumHolder::Enum>
Enumeration<EnumHolder, defVal>::enum2string = typename Enumeration<EnumHolder, defVal>::Filler();

template <typename EnumHolder, const typename EnumHolder::Enum defVal>
const typename Enumeration<EnumHolder, defVal>::Enum
Enumeration<EnumHolder, defVal>::defaultValue = defVal;

template <typename EnumHolder, const typename EnumHolder::Enum defVal>
std::ostream & operator << ( std::ostream & s, const Enumeration<EnumHolder, defVal> & o ) {
    return s << o.toString();
}

template <typename EnumHolder, const typename EnumHolder::Enum defVal>
std::istream & operator >> ( std::istream & s, Enumeration<EnumHolder, defVal> & o ) {
    typedef Enumeration<EnumHolder, defVal> EnumWrapper;
    std::string str;
    s >> str;
    o = EnumWrapper::fromString(str, std::nothrow);
    return s;
}

} // namespace user_journal
