#ifndef EXCEPTION_HANDLER_H_162106032014
#define EXCEPTION_HANDLER_H_162106032014

#include <stdexcept>
#include <boost/shared_ptr.hpp>

namespace user_journal {

class ExceptionHandler {
public:
    virtual ~ExceptionHandler() {}
    virtual void handle( const std::exception & e ) const = 0;
    virtual void handleUnknown() const = 0;
};

typedef boost::shared_ptr<ExceptionHandler> ExceptionHandlerPtr;

} // namespace user_journal



#endif /* EXCEPTION_HANDLER_H_162106032014 */
