#ifndef USER_JOURNAL_JOURNAL_H
#define USER_JOURNAL_JOURNAL_H

#include <user_journal/parameters/operation_parameters.h>
#include <user_journal/parameters/request_parameters.h>
#include <user_journal/entry.h>
#include <user_journal/writer.h>

namespace user_journal {

class Journal {
public:
    Journal(parameters::RequestParametersPtr requestInfo, WriterPtr writer)
        : requestInfo(requestInfo), writer(writer) {}

    template<typename OperationParams, typename... ArgsT>
    void write(ArgsT&& ... args) const {
        auto params = OperationParams(std::forward<ArgsT>(args)...);
        writer->write(requestInfo->uid(), JournalEntry<OperationParams>(requestInfo, std::move(params)));
    }

private:
    parameters::RequestParametersPtr requestInfo;
    WriterPtr writer;

    template<typename Params>
    class JournalEntry : public Entry {
        parameters::RequestParametersPtr requestInfo;
        Params operationParams;
    public:
        JournalEntry(parameters::RequestParametersPtr requestInfo, Params operationParams)
            : requestInfo(requestInfo), operationParams(std::move(operationParams)) {}

        virtual void map(const Mapper & m) const override {
            requestInfo->map(m);
            operationParams.map(m);
        }
    };
};

} // namespace user_journal

#endif /* USER_JOURNAL_JOURNAL_H */
