#ifndef LOGGING_H_144807122013
#define LOGGING_H_144807122013

#include <string>
#include <boost/shared_ptr.hpp>

namespace user_journal {
namespace logging {

class Log {
public:
    virtual ~Log() {}
    virtual void warning( const std::string & uid, const std::string & method,
            const std::string & message, int code ) = 0;
    virtual void error( const std::string & uid, const std::string & method,
            const std::string & message, int code ) = 0;
    virtual void notice( const std::string & uid, const std::string & method,
            const std::string & message ) = 0;
    virtual void debug( const std::string & uid, const std::string & method,
            const std::string & message ) = 0;
};

typedef boost::shared_ptr<Log> LogPtr;

} // namespace logging
} //namespace user_journal


#endif /* LOGGING_H_144807122013 */
