#ifndef USER_JOURNAL_MAPPER_H
#define USER_JOURNAL_MAPPER_H

#include <user_journal/operation.h>
#include <user_journal/target.h>
#include <user_journal/date.h>
#include <string>
#include <list>
#include <vector>

namespace user_journal {

struct Mapper {
    virtual ~Mapper() = default;
    virtual void mapValue( const Operation & v, const std::string & name ) const = 0;
    virtual void mapValue( const Target & v, const std::string & name ) const = 0;
    virtual void mapValue( const std::string & v, const std::string & name ) const = 0;
    virtual void mapValue( const Date & v, const std::string & name ) const = 0;
    virtual void mapValue( bool v, const std::string & name ) const = 0;
    virtual void mapValue( int v, const std::string & name ) const = 0;
    virtual void mapValue( size_t v, const std::string & name ) const = 0;
    virtual void mapValue( std::time_t v, const std::string & name ) const = 0;
    virtual void mapValue( const std::vector<std::string> & v, const std::string & name ) const = 0;
};

} // namespace user_journal

#endif /* USER_JOURNAL_MAPPER_H */
