#pragma once

#include <user_journal/enumeration.h>

namespace user_journal {

/**
 * Operations are logged. For more info see
 *     http://wiki.yandex-team.ru/Pochta/attendance for more details.
 */
struct __Operation {
    enum Enum {
        unknown,
        mark,
        label,
        unlabel,
        move,
        send,
        abuse,
        create,
        deletee,
        rename,
        clear,
        append,
        imap_flags,
        imap_purge,
        imap_copy,
        change_symbol,
        authorization,
        receive,
        copy,
        reset_fresh,
        settings_update,
        setPop3,
        trash,
        fetch_body,
        registration,
        change_so_type,
        undo_sending,
        move_to_tab
    };
    typedef Enum2String<Enum>::Map Map;
    void fill(Map & map) const {
#define ADD_ENUM_TO_MAP(name, map) map.insert(Map::value_type(name, #name))
        ADD_ENUM_TO_MAP(unknown, map);
        ADD_ENUM_TO_MAP(mark, map);
        ADD_ENUM_TO_MAP(label, map);
        ADD_ENUM_TO_MAP(unlabel, map);
        ADD_ENUM_TO_MAP(move, map);
        ADD_ENUM_TO_MAP(send, map);
        ADD_ENUM_TO_MAP(abuse, map);
        ADD_ENUM_TO_MAP(create, map);
        map.insert(Map::value_type(deletee, "delete"));
        ADD_ENUM_TO_MAP(rename, map);
        ADD_ENUM_TO_MAP(clear, map);
        ADD_ENUM_TO_MAP(append, map);
        ADD_ENUM_TO_MAP(imap_flags, map);
        ADD_ENUM_TO_MAP(imap_purge, map);
        ADD_ENUM_TO_MAP(imap_copy, map);
        ADD_ENUM_TO_MAP(change_symbol, map);
        ADD_ENUM_TO_MAP(authorization, map);
        ADD_ENUM_TO_MAP(receive, map);
        ADD_ENUM_TO_MAP(copy, map);
        ADD_ENUM_TO_MAP(reset_fresh, map);
        ADD_ENUM_TO_MAP(settings_update, map);
        ADD_ENUM_TO_MAP(setPop3, map);
        ADD_ENUM_TO_MAP(trash, map);
        ADD_ENUM_TO_MAP(fetch_body, map);
        ADD_ENUM_TO_MAP(registration, map);
        ADD_ENUM_TO_MAP(change_so_type, map);
        ADD_ENUM_TO_MAP(undo_sending, map);
        ADD_ENUM_TO_MAP(move_to_tab, map);
#undef ADD_ENUM_TO_MAP
    }
    typedef __Operation Filler;
};

typedef Enumeration<__Operation> Operation;
}
