#ifndef USER_JOURNAL_PARAMETERS_FOLDERS_H
#define USER_JOURNAL_PARAMETERS_FOLDERS_H

#include <user_journal/parameters/operation_parameters.h>

namespace user_journal {
namespace parameters {

template <Operation::Enum operationT, typename ... Args>
using FoldersParams = OperationParameters<Target::folders, operationT, Args...>;

using CreateFolder = FoldersParams<Operation::create,
        id::fid,
        id::parentFid,
        id::folderName,
        id::folderType,
        id::folderSymbol>;

using RenameFolder = FoldersParams<Operation::rename,
        id::fid,
        id::parentFid,
        id::folderName>;

using DeleteFolder = FoldersParams<Operation::deletee,
        id::fid>;

using ClearFolder = FoldersParams<Operation::clear,
        id::fid>;

using MoveFolderMessages = FoldersParams<Operation::move,
        id::srcFid,
        id::destFid>;

using ChangeFolderSymbol = FoldersParams<Operation::change_symbol,
        id::fid,
        boost::optional<id::folderSymbol>>;

using SetPop3 = FoldersParams<Operation::setPop3,
        id::fids>;

} // namespace parameters
} // namespace user_journal

#endif /* USER_JOURNAL_PARAMETERS_FOLDERS_H */
